//////////////////////////////////////////////
// Script.js
//
//////////////////////////////////////////////

/// Class ------------------------------------
	
nkScriptsTests.Script = class Script extends nkDebug.TestClass
{
	static instance = new Script ("nkScriptsTests.Script") ;

	nkTests =
	{
		__testShutdown__ : function ()
		{
			nkScripts.EnvironmentManager.kill() ;
			nkScripts.ScriptManager.kill() ;
		},

		InvalidScriptLoadingNoInterpreter : function ()
		{
			// Make script & populate
			const script = nkScripts.ScriptManager.getInstance().createOrRetrieve("Script") ;
			script.setSources("return 5") ;
			nkDebug.TestUtils.check(!script.load(), "Script should not load") ;

			const compilationResult = script.getLastCompilationResult() ;
			nkDebug.TestUtils.check(!compilationResult._success, "Result states success while it's a failure") ;
			nkDebug.TestUtils.check(compilationResult._failureType === nkScripts.COMPILATION_FAILURE_TYPE.INTERPRETER_UNKNOWN, "Unexpected failure type") ;
		},

		BadScriptError : function ()
		{
			// Prepare environment and script
			const env = nkScripts.EnvironmentManager.getInstance().createOrRetrieve("env") ;
			env.setEnvironmentFor(nkScripts.INTERPRETER.LUA) ;

			const script = nkScripts.ScriptManager.getInstance().createOrRetrieve("script") ;
			script.setTargetInterpreter(nkScripts.INTERPRETER.LUA) ;
			script.setSources("pirnt('bark'") ;

			// Check sanity
			nkDebug.TestUtils.check(!script.load(), "Script should not load") ;

			const result = script.getLastCompilationResult() ;
			nkDebug.TestUtils.check(!result._success, "Result states it's a success when it should be a failure") ;
			nkDebug.TestUtils.check(result._failureType === nkScripts.COMPILATION_FAILURE_TYPE.SYNTAX, "Unexpected failure type") ;
		},

		GoodScriptNoError : function ()
		{
			// Prepare environment and script
			const env = nkScripts.EnvironmentManager.getInstance().createOrRetrieve("env") ;
			env.setEnvironmentFor(nkScripts.INTERPRETER.LUA) ;

			const script = nkScripts.ScriptManager.getInstance().createOrRetrieve("script") ;
			script.setTargetInterpreter(nkScripts.INTERPRETER.LUA) ;
			script.setSources("print('bark')") ;

			// Check sanity
			nkDebug.TestUtils.check(script.load(), "Script should load") ;

			const result = script.getLastCompilationResult() ;
			nkDebug.TestUtils.check(result._success, "Result states it's a failure when it should be a success") ;
			nkDebug.TestUtils.check(result._failureType === nkScripts.COMPILATION_FAILURE_TYPE.NO_ERROR, "Unexpected failure type") ;
		}
	}
}